/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.planning;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.Collection;
import java.util.List;

public abstract class SingleTypeContributor<D extends Deployed<?, ?>> {
    protected final Predicate<Delta> isOfType;
    protected List<D> deployedsCreated;
    protected List<TypedDelta> deployedsModified;
    protected List<D> deployedsRemoved;

    protected SingleTypeContributor(Class<? extends D> classOfDeployed) {
        this.isOfType = new IsSubtypeOf(Type.valueOf(classOfDeployed));
    }

    protected void filterDeltas(Deltas deltas, DeploymentPlanningContext ctx) {
        this.deployedsCreated = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)deltas.getDeltas(), (Predicate)Predicates.and(this.isOfType, (Predicate)SingleTypeContributor.operationIs(Operation.CREATE))), (Function)new Function<Delta, D>(){

            public D apply(Delta input) {
                return input.getDeployed();
            }
        }));
        this.deployedsModified = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)deltas.getDeltas(), (Predicate)Predicates.and(this.isOfType, (Predicate)SingleTypeContributor.operationIs(Operation.MODIFY))), (Function)new Function<Delta, TypedDelta>(){

            public TypedDelta apply(Delta input) {
                return new TypedDelta(input);
            }
        }));
        this.deployedsRemoved = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)deltas.getDeltas(), (Predicate)Predicates.and(this.isOfType, (Predicate)SingleTypeContributor.operationIs(Operation.DESTROY))), (Function)new Function<Delta, D>(){

            public D apply(Delta input) {
                return input.getPrevious();
            }
        }));
    }

    protected static OperationEquals operationIs(Operation operationToMatch) {
        return new OperationEquals(operationToMatch);
    }

    protected class TypedDelta
    implements Delta {
        private final Delta delegate;

        private TypedDelta(Delta delegate) {
            this.delegate = delegate;
        }

        public Operation getOperation() {
            return this.delegate.getOperation();
        }

        public D getPrevious() {
            return this.delegate.getPrevious();
        }

        public D getDeployed() {
            return this.delegate.getDeployed();
        }
    }

    protected static class IsSubtypeOf
    implements Predicate<Delta> {
        private final Collection<Type> subtypes;

        protected IsSubtypeOf(Type typeToMatch) {
            this.subtypes = DescriptorRegistry.getSubtypes((Type)typeToMatch);
            this.subtypes.add(typeToMatch);
        }

        public boolean apply(Delta input) {
            return this.subtypes.contains(IsSubtypeOf.getType(input));
        }

        private static Type getType(Delta delta) {
            return delta.getOperation().equals((Object)Operation.DESTROY) ? delta.getPrevious().getType() : delta.getDeployed().getType();
        }
    }

    protected static class OperationEquals
    implements Predicate<Delta> {
        private final Operation operationToMatch;

        protected OperationEquals(Operation operationToMatch) {
            this.operationToMatch = operationToMatch;
        }

        public boolean apply(Delta input) {
            return input.getOperation().equals((Object)this.operationToMatch);
        }
    }
}

