package com.xebialabs.deployit.plugin.generic.processor;


import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;

import java.util.Collections;
import java.util.List;

public class DeployedInjector {

    @PrePlanProcessor
    public List<DeploymentStep> inject(DeltaSpecification deltaSpec) {
        for (Delta delta : deltaSpec.getDeltas()) {
            injectDeployed(delta.getPrevious(), deltaSpec);
            injectDeployed(delta.getDeployed(), deltaSpec);
        }
        return Collections.emptyList();
    }

    private void injectDeployed(Deployed<?, ?> deployed, DeltaSpecification deltaSpec) {
        if (deployed instanceof AbstractDeployed) {
            AbstractDeployed<?> abstractDeployed = (AbstractDeployed<?>) deployed;
            injectDeployed(abstractDeployed, deltaSpec);
        }
    }

    protected void injectDeployed(AbstractDeployed<?> deployed, DeltaSpecification deltaSpec) {
        deployed.setPlanOperation(deltaSpec.getOperation());
        deployed.setDeployedApplication(deltaSpec.getDeployedApplication());
    }
}
