package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@SuppressWarnings("serial")
public abstract class BaseDeploymentStep extends BaseStep<DeploymentExecutionContext> implements DeploymentStep {


    private int order;

    protected BaseDeploymentStep(int order, String description, HostContainer container) {
        super(description, container);
        this.order = order;
    }

    protected BaseDeploymentStep(int order, HostContainer container) {
        this(order, null, container);
    }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public Result execute(DeploymentExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
    }
}
