package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import org.slf4j.MDC;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
public class TemplateArtifactCopyStep extends ArtifactCopyStep {

	private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";

	private Map<String, Object> vars;

    private String templatePath;

    public TemplateArtifactCopyStep(int order, HostContainer container, Map<String, Object> vars, String templatePath, String targetPath) {
        super(order, null, container, targetPath);
        this.vars = newHashMap(vars);
        this.vars.put("step",this);
        this.templatePath = templatePath;
        Preconditions.checkNotNull(templatePath);
    }

    @Override
    protected Result doExecute() throws Exception {
    	MDC.put(MDC_KEY_TEMPLATE_PATH, templatePath);
    	try {
    		return super.doExecute();
    	} finally {
    		MDC.remove(MDC_KEY_TEMPLATE_PATH);
    	}
    }

    @Override
    protected OverthereFile resolveSourceFile() {
        OverthereFile localTemp = getLocalConnection().getTempFile("generic_plugin", ".tmp");
        evaluateTemplate(localTemp, templatePath, vars);
        return localTemp;
    }
}

