/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.step.BaseStep;
import com.xebialabs.deployit.plugin.overthere.DefaultProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BaseExecutionStep
extends BaseStep {
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private String scriptTemplatePath;
    private Map<String, Object> vars;
    private File artifact;
    private List<File> fileResources = Lists.newArrayList();
    private List<String> classpathResources = Lists.newArrayList();
    private List<String> templateClasspathResources = Lists.newArrayList();
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.generic.scripts");

    public BaseExecutionStep(String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(description, container);
        this.scriptTemplatePath = scriptPath;
        this.vars = Maps.newHashMap(vars);
        this.vars.put("step", this);
        Preconditions.checkNotNull((Object)this.scriptTemplatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepExitCode doExecute() throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptTemplatePath);
        try {
            this.uploadArtifactIfPresent();
            this.uploadFileResources();
            this.uploadClasspathResources();
            this.uploadTemplateClasspathResources();
            OverthereFile executable = this.uploadScriptToExecute(this.scriptTemplatePath);
            this.setWorkingDirectory();
            StepExitCode stepExitCode = this.executeScript(executable);
            return stepExitCode;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    protected OverthereFile uploadArtifactIfPresent() {
        if (this.artifact != null) {
            return this.uploadToWorkingDirectory(this.artifact, this.artifact.getName());
        }
        return null;
    }

    protected void uploadFileResources() {
        for (File fileResource : this.fileResources) {
            this.uploadToWorkingDirectory(fileResource, fileResource.getName());
        }
    }

    protected void uploadClasspathResources() {
        for (String cpResource : this.classpathResources) {
            String fileName = this.substringAfterLast(cpResource, '/', cpResource);
            this.uploadToWorkingDirectory(Resources.getResource((String)cpResource), fileName);
        }
    }

    protected void uploadTemplateClasspathResources() {
        for (String cpTemplate : this.templateClasspathResources) {
            this.uploadTemplateResourceToWorkingDirectory(cpTemplate, null);
        }
    }

    protected void setWorkingDirectory() {
        this.getRemoteConnection().setWorkingDirectory(this.getRemoteWorkingDirectory());
    }

    protected OverthereFile uploadScriptToExecute(String scriptTemplatePath) {
        OverthereFile executable = this.uploadTemplateResourceToWorkingDirectory(scriptTemplatePath, scriptsLogger);
        executable.setExecutable(true);
        return executable;
    }

    private OverthereFile uploadTemplateResourceToWorkingDirectory(String template, Logger logger) {
        String osSpecificTemplate = this.resolveOsSpecificTemplate(template);
        String content = this.evaluateTemplate(osSpecificTemplate, this.vars);
        if (logger != null) {
            ScriptUtils.dumpScript((String)osSpecificTemplate, (String)content, (Logger)logger);
        }
        String fileName = this.resolveOsSpecificFileName(osSpecificTemplate);
        return this.uploadToWorkingDirectory(content, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StepExitCode executeScript(OverthereFile executable) {
        CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
        DefaultProcessOutputHandler handler = new DefaultProcessOutputHandler(this.getCtx());
        try {
            this.getCtx().logOutput("Executing " + executable.getPath() + " on host " + this.getContainer().getHost());
            int rc = this.getRemoteConnection().execute((OverthereProcessOutputHandler)handler, cmdLine);
            if (rc != 0) {
                this.getCtx().logError("Execution failed with return code " + rc);
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
        finally {
            handler.close();
        }
    }

    public List<File> getFileResources() {
        return this.fileResources;
    }

    public void setFileResources(List<File> fileResources) {
        this.fileResources = fileResources;
    }

    public List<String> getClasspathResources() {
        return this.classpathResources;
    }

    public void setClasspathResources(List<String> classpathResources) {
        this.classpathResources = classpathResources;
    }

    public List<String> getTemplateClasspathResources() {
        return this.templateClasspathResources;
    }

    public void setTemplateClasspathResources(List<String> templateClasspathResources) {
        this.templateClasspathResources = templateClasspathResources;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public void setArtifact(File artifact) {
        this.artifact = artifact;
    }

    public String getUploadedArtifactPath() {
        if (this.artifact != null) {
            return this.getRemoteWorkingDirectory().getPath() + this.getContainer().getHost().getOs().getFileSeparator() + this.artifact.getName();
        }
        return null;
    }

    protected String resolveOsSpecificFileName(String template) {
        String fileExt;
        String osSpecificFile = this.substringAfterLast(template, '/', template);
        if (osSpecificFile.endsWith(".ftl")) {
            osSpecificFile = osSpecificFile.substring(0, osSpecificFile.lastIndexOf(".ftl"));
        }
        if ((fileExt = this.substringAfterLast(osSpecificFile, '.')) == null) {
            OperatingSystemFamily os = this.getContainer().getHost().getOs();
            osSpecificFile = osSpecificFile + os.getScriptExtension();
        }
        return osSpecificFile;
    }
}

