/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlTaskDelegate {
    public static List<Step> dispatch(String name, Map<String, String> args, ConfigurationItem item, HostContainer container) {
        return ControlTaskDelegate.dispatch(name, args, item, container, null);
    }

    public static List<Step> dispatch(String name, Map<String, String> args, ConfigurationItem item, HostContainer container, Parameters params) {
        String script = args.get("script");
        if (Strings.isNullOrEmpty((String)script)) {
            String scriptPropertyName = name + "Script";
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(scriptPropertyName);
            Preconditions.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Control task script property %s not defined for CI type %s", (Object[])new Object[]{scriptPropertyName, item.getType()});
            script = (String)propertyDescriptor.get(item);
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)script) ? 1 : 0) != 0, (Object)"Argument 'script' is required.");
        HashMap thisVarContext = Maps.newHashMap();
        thisVarContext.put("container", container);
        if (item instanceof AbstractDeployed) {
            thisVarContext.put("deployed", item);
        }
        if (params != null) {
            thisVarContext.put("params", params);
        }
        String scriptName = ConfigurationHolder.resolveExpression(script, (Object)thisVarContext);
        Preconditions.checkArgument((boolean)(container instanceof HostContainer), (String)"Control task '%s' with shell script '%s' can only be run against a container implementing remote.HostContainer. Container '%s' does not.", (Object[])new Object[]{name, scriptName, container});
        String desc = "Executing " + name + " on " + item;
        return Collections.singletonList(new ScriptExecutionStep(1, scriptName, container, thisVarContext, desc));
    }

    @Delegate(name="generic")
    public static List<Step> genericDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        if (item instanceof HostContainer) {
            return ControlTaskDelegate.dispatch(name, args, item, (HostContainer)item, params);
        }
        if (item instanceof AbstractDeployed) {
            Container container = ((AbstractDeployed)item).getContainer();
            Preconditions.checkArgument((boolean)(container instanceof HostContainer), (String)"Control task '%s' on '%s' can only be run against a container implementing remote.HostContainer. Container '%s' does not.", (Object[])new Object[]{name, item, container});
            return ControlTaskDelegate.dispatch(name, args, item, (HostContainer)container, params);
        }
        throw new IllegalStateException(String.format("Can only be invoked on overthere.HostContainer or generic.AbstractDeployed types, not on %s[%s]", item, item.getType()));
    }
}

