/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.mail.SmtpServer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.slf4j.MDC;

public class InstructionStep
extends BaseDeploymentStep {
    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";
    private Map<String, Object> vars;
    private String templatePath;
    private boolean paused = false;
    private List<String> toAddresses = Lists.newArrayList();
    private String subject;
    private String fromAddress;
    private SmtpServer mailServer;

    public InstructionStep(int order, String description, HostContainer container, Map<String, Object> vars, String templatePath) {
        super(order, description, container);
        this.vars = Maps.newHashMap(vars);
        this.vars.put("step", this);
        this.templatePath = templatePath;
        Preconditions.checkNotNull((Object)templatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StepExitCode doExecute() throws Exception {
        MDC.put((String)MDC_KEY_TEMPLATE_PATH, (String)this.templatePath);
        try {
            String instructions = this.renderEmailTemplate(this.templatePath, this.vars);
            if (this.paused) {
                this.getCtx().logOutput("Assuming manual process performed. Continuing...");
                this.getCtx().logOutput("------------");
                this.getCtx().logOutput("Instructions");
                this.getCtx().logOutput("------------");
                this.getCtx().logOutput(instructions);
                StepExitCode stepExitCode = StepExitCode.SUCCESS;
                return stepExitCode;
            }
            this.mailInstructions(instructions);
            this.getCtx().logOutput(instructions);
            this.paused = true;
            StepExitCode stepExitCode = StepExitCode.PAUSE;
            return stepExitCode;
        }
        finally {
            MDC.remove((String)MDC_KEY_TEMPLATE_PATH);
        }
    }

    protected void mailInstructions(String instructions) {
        if (!this.toAddresses.isEmpty() && this.mailServer != null) {
            this.getCtx().logOutput("Mailing instructions to " + Joiner.on((char)',').join(this.toAddresses));
            this.subject = Strings.isNullOrEmpty((String)this.subject) ? this.getDescription() : this.subject;
            try {
                this.mailServer.sendMessage(this.subject, instructions, this.toAddresses, this.fromAddress);
            }
            catch (MessagingException e) {
                this.getCtx().logError("Failed to send mail.", (Throwable)e);
                this.getCtx().logOutput(Strings.repeat((String)"-", (int)50));
            }
        }
    }

    protected String renderEmailTemplate(String template, Map<String, Object> vars) throws IOException, TemplateException {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        Template loadedTemplate = cfg.getTemplate(template);
        StringWriter sw = new StringWriter();
        loadedTemplate.process(vars, (Writer)sw);
        return sw.toString();
    }

    public List<String> getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public SmtpServer getMailServer() {
        return this.mailServer;
    }

    public void setMailServer(SmtpServer mailServer) {
        this.mailServer = mailServer;
    }
}

