/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.mail.SmtpServer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.slf4j.MDC;

@StepMetadata(name="manual")
public class InstructionStep
implements Step,
PreviewStep {
    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";
    @StepParameter(description="The execution order of the step")
    private Integer order;
    @StepParameter(description="Description of this step, as it should appear in generated deployment plans")
    private String description;
    @StepParameter(name="freemarkerContext", description="Dictionary that contains all values available in the template", required=false, calculated=true)
    private Map<String, Object> vars = new HashMap<String, Object>();
    @StepParameter(name="messageTemplate", description="The path to the email template to display and send out")
    private String templatePath;
    @StepParameter(name="mailTo", description="The list of email receivers to send instructions to")
    private List<String> toAddresses;
    @StepParameter(description="The email subject line", calculated=true)
    private String subject;
    @StepParameter(name="mailFrom", description="The email's sender ('From:') email address")
    private String fromAddress;
    @StepParameter(description="Mail server that is used to send emails", calculated=true)
    private SmtpServer mailServer;
    private boolean paused = false;
    private Preview preview;

    public InstructionStep() {
    }

    public InstructionStep(int order, String description, HostContainer container, Map<String, Object> vars, String templatePath) {
        this.order = order;
        this.description = description;
        this.vars = Maps.newHashMap(vars);
        this.vars.put("step", this);
        this.templatePath = templatePath;
        this.toAddresses = Lists.newArrayList();
        Preconditions.checkNotNull((Object)templatePath);
    }

    @RulePostConstruct
    protected void doPostConstruct(StepPostConstructContext ctx) {
        if (this.mailServer == null) {
            this.mailServer = SmtpServer.getMailServer(ctx.getDeployedApplication().getEnvironment(), ctx.getRepository());
        }
        this.vars = ContextHelper.defaultContext((StepPostConstructContext)ctx, this.vars);
        if (this.subject == null) {
            this.subject = this.description;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        MDC.put((String)MDC_KEY_TEMPLATE_PATH, (String)this.templatePath);
        try {
            String instructions = this.renderEmailTemplate(this.templatePath, this.vars);
            if (!this.paused) {
                this.sendInstructions(ctx, instructions);
                StepExitCode stepExitCode = this.pauseExecution();
                return stepExitCode;
            }
            StepExitCode stepExitCode = this.continueExecution(ctx, instructions);
            return stepExitCode;
        }
        finally {
            MDC.remove((String)MDC_KEY_TEMPLATE_PATH);
        }
    }

    private void sendInstructions(ExecutionContext ctx, String instructions) {
        this.mailInstructions(instructions, ctx);
        ctx.logOutput(instructions);
    }

    private StepExitCode pauseExecution() {
        this.paused = true;
        return StepExitCode.PAUSE;
    }

    private StepExitCode continueExecution(ExecutionContext ctx, String instructions) {
        ctx.logOutput("Assuming manual process performed. Continuing...");
        ctx.logOutput("------------");
        ctx.logOutput("Instructions");
        ctx.logOutput("------------");
        ctx.logOutput(instructions);
        return StepExitCode.SUCCESS;
    }

    protected void mailInstructions(String instructions, ExecutionContext ctx) {
        if (!this.toAddresses.isEmpty() && this.mailServer != null) {
            ctx.logOutput("Mailing instructions to " + Joiner.on((char)',').join(this.toAddresses));
            this.subject = Strings.isNullOrEmpty((String)this.subject) ? this.getDescription() : this.subject;
            try {
                this.mailServer.sendMessage(this.subject, instructions, this.toAddresses, this.fromAddress);
            }
            catch (MessagingException e) {
                ctx.logError("Failed to send mail.", (Throwable)e);
                ctx.logOutput(Strings.repeat((String)"-", (int)50));
            }
        } else {
            ctx.logOutput("Not sending email instructions.");
        }
    }

    protected String renderEmailTemplate(String template, Map<String, Object> vars) throws IOException, TemplateException {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        Template loadedTemplate = cfg.getTemplate(template);
        StringWriter sw = new StringWriter();
        loadedTemplate.process(vars, (Writer)sw);
        return sw.toString();
    }

    public List<String> getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public SmtpServer getMailServer() {
        return this.mailServer;
    }

    public void setMailServer(SmtpServer mailServer) {
        this.mailServer = mailServer;
    }

    public Preview getPreview() {
        if (this.preview == null) {
            try {
                this.preview = Preview.withSourcePathAndContents((String)this.templatePath, (String)this.renderEmailTemplate(this.templatePath, this.vars));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.preview;
    }
}

