package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class CiAwareObjectWrapper extends DefaultObjectWrapper {

    private ArtifactUploader uploader;
    private final Boolean maskPasswords;

    public CiAwareObjectWrapper() {
        this(null, false);
    }

    /**
     * @deprecated Use {@link #CiAwareObjectWrapper(ArtifactUploader, boolean)} instead.
     */
    public CiAwareObjectWrapper(ArtifactUploader uploader) {
        this(uploader, false);
    }

    public CiAwareObjectWrapper(ArtifactUploader uploader, boolean maskPasswords) {
        this.uploader = uploader;
        this.maskPasswords = maskPasswords;
    }

    @Override
    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj instanceof ConfigurationItem) {
            return new CiTemplateModel((ConfigurationItem) obj, this, maskPasswords);
        } else {
            return super.wrap(obj);
        }
    }

    ArtifactUploader getUploader() {
        return uploader;
    }

    BeansWrapper getWrapper() {
        return this;
    }
}
