package com.xebialabs.deployit.plugin.generic.deployed;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A script executed on a generic container whose deployable artifact supports placeholder replacement")
@Placeholders
public class ExecutedScriptWithDerivedArtifact<D extends DeployableArtifact> extends ExecutedScript<D> implements DerivedArtifact<D> {

    @Property(required = false, category= "Placeholders", description = "A key/value pair mapping of placeholders in the deployed artifact to their values. Special values are <ignore> and <empty>")
    private Map<String, String> placeholders = newHashMap();

    private OverthereFile placeholderProcessedFile;

    protected OverthereFile getArtifactIfPresent() {
        return placeholderProcessedFile;
    }

    @Override
    public D getSourceArtifact() {
        return getDeployable();
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return placeholders;
    }

    @Override
    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }
    
    @Override
    public OverthereFile getFile() {
        return placeholderProcessedFile;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }
}
