package com.xebialabs.deployit.plugin.generic.processor;


import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;

import java.util.Collections;
import java.util.List;

public class DeployedInjector {

    @PrePlanProcessor
    public static List<Step> inject(DeltaSpecification deltaSpec) {
        for (Delta delta : deltaSpec.getDeltas()) {
            injectDeployed(delta.getPrevious(), deltaSpec.getOperation(), deltaSpec.getPreviousAppliedDistribution());
            injectDeployed(delta.getDeployed(), deltaSpec.getOperation(), deltaSpec.getAppliedDistribution());
        }
        return Collections.emptyList();
    }

    protected static void injectDeployed(Deployed<?, ?> deployed, Operation operation, AppliedDistribution deployedApplication) {
        if (deployed instanceof AbstractDeployed) {
            AbstractDeployed<?> abstractDeployed = (AbstractDeployed<?>) deployed;
            abstractDeployed.setPlanOperation(operation);
            abstractDeployed.setDeployedApplication(deployedApplication);
        }
    }

}
