/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.ci;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.generic.ci.BaseGenericContainer;
import com.xebialabs.deployit.plugin.generic.ci.GenericContainer;
import com.xebialabs.deployit.plugin.overthere.Host;

@Metadata(virtual=true, description="A container that is nested with another container")
public class NestedContainer
extends BaseGenericContainer
implements GenericContainer {
    @Override
    public <T extends GenericContainer> T getParentContainer() {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (pd.getKind() != PropertyKind.CI || !pd.isAsContainment()) continue;
            Preconditions.checkArgument((pd.getReferencedType().instanceOf(Type.valueOf((String)"generic.Container")) || pd.getReferencedType().instanceOf(Type.valueOf((String)"generic.NestedContainer")) ? 1 : 0) != 0, (String)"Nested container [%s] of type [%s] has a parent (as-containment) relationship to a type that is not a generic (nested) container but a [%s]", (Object[])new Object[]{this, this.getType(), pd.getReferencedType()});
            return (T)((GenericContainer)pd.get((ConfigurationItem)this));
        }
        throw new IllegalStateException(String.format("Nested container [%s] of type [%s] does not have a parent (as-containment) relationship to another generic (nested) container.", this, this.getType()));
    }

    public Host getHost() {
        return this.getParentContainer().getHost();
    }
}

