#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided virtual directory path or use the deployed name.
$virtualDirectoryPath = if($deployed.virtualDirectoryPath) { $deployed.virtualDirectoryPath } else { $deployed.name }

# Destroy virtual directory, if it exists.
$virtDirPath = "IIS:\Sites\$($deployed.websiteName)\$virtualDirectoryPath"
if (Test-Path $virtDirPath) {
    Write-Host "Destroying virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)]."
    Get-ChildItem $virtDirPath -Recurse | Sort-Object -Property FullName -Descending | Remove-Item -Force | Out-Null
} else {
    Write-Host "Virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)] has already been destroyed."
}
