# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Destroy application pool, if it exists.
$appPoolPath = "IIS:\AppPools\$applicationPoolName";
if (Test-Path $appPoolPath) {
    Write-Output "Destroying application pool [$applicationPoolName]."
    Remove-Item -Recurse -Force $appPoolPath | Out-Null
} else {
    Write-Output "Application pool [$applicationPoolName] has already been destroyed."
}
