# Get provided application path or use the deployed name.
$applicationPath = if($deployed.applicationPath) { $deployed.applicationPath } else { $deployed.name }

# Destroy application, if it exists.
$appPath = "IIS:\Sites\$($deployed.websiteName)\$applicationPath"
if (Test-Path $appPath) {
    Write-Output "Destroying application [$applicationPath] in website [$($deployed.websiteName)]."
    Remove-Item $appPath -Recurse -Force  | Out-Null
} else {
    Write-Output "Application [$applicationPath] has already been destroyed."
}
