# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Verify application pool name is not being changed.
if($previousDeployed) {
    $previousApplicationPoolName = if($previousDeployed.applicationPoolName) { $previousDeployed.applicationPoolName } else { $previousDeployed.name }
    if($applicationPoolName -ne $previousApplicationPoolName) {
        Write-Output "Renaming an application pool is not supported. Undeploy and deploy the application pool instead."
        Exit 1
    }
}

# Verify username and password are provided if serviceAccount if set to 'SpecificUser'.
if ($deployed.serviceAccount -eq "SpecificUser") {
    if (!$deployed.username) {
        throw "Username is required when service account is [SpecificUser]."
    }
    if (!$deployed.password) {
        throw "Password is required when service account is [SpecificUser]."
    }
}

# Check whether application pool already exists and then either retrieve or create it.
$appPoolPath = "IIS:\AppPools\$applicationPoolName"
if (Test-Path $appPoolPath) {
    Write-Output "Modifying existing application pool [$applicationPoolName]."

    $applicationPool = Get-Item $appPoolPath
} else {
    Write-Output "Creating new application pool [$applicationPoolName]."

    $applicationPool = New-Item $appPoolPath

    # Stopping application pool so that we can configure it correctly before starting it properly from start-application-pool.ps1
    Stop-WebAppPool $applicationPoolName
}

# Set application pool properties.
$applicationPool.managedRuntimeVersion = $deployed.managedRuntimeVersion
$applicationPool.managedPipelineMode = if ($deployed.useClassicManagedPipeline) { 'Classic' } else { 'Integrated' }

$applicationPool.ProcessModel.IdentityType = $deployed.serviceAccount
if ($deployed.serviceAccount -eq "SpecificUser") {
    $applicationPool.ProcessModel.UserName = $deployed.username
    $applicationPool.ProcessModel.Password = $deployed.password
}

# Save application pool.
$applicationPool | Set-Item



