# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Stop application pool, if it exists.
if (Test-Path "IIS:\AppPools\$applicationPoolName") {
    Write-Output "Stopping application pool [$applicationPoolName]."
    Stop-WebAppPool -Name $applicationPoolName -ErrorAction SilentlyContinue | Out-Null
} else {
    Write-Output "Application pool [$applicationPoolName] does not exist and will not be stopped."
}
