# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Stop website, if it exists.
$websitePath = "IIS:\Sites\$websiteName"
if (Test-Path $websitePath) {
    Write-Output "Stopping website [$websiteName]."
    Stop-Website -Name $websiteName -ErrorAction SilentlyContinue | Out-Null
} else {
    Write-Output "Website [$websiteName] does not exist and will not be stopped."
}

