# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Start application pool, if it exists.
$appPool = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class IIsApplicationPool -Filter "Name ='W3SVC/APPPOOLS/$applicationPoolName'"
if($appPool) {
    Write-Output "Starting application pool [$applicationPoolName]."
    $appPool.Start()
} else {
    Write-Output "Application pool [$applicationPoolName] does not exist and will not be started."
}


