# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Stop website, if it exists and has not already been stopped.
$websitePath = "IIS:\Sites\$websiteName"
if (!(Test-Path $websitePath)) {
    Write-Host "Website [$websiteName] does not exist."
    Exit 1
} elseif((Get-Item $websitePath).State -eq "Stopped") {
    Write-Host "Website [$websiteName] has already been stopped."
} else {
    Write-Host "Stopping website [$websiteName]."
    Stop-Website -Name $websiteName -ErrorAction SilentlyContinue | Out-Null
}

