Function inspectApplication($website, $app, $virtualDirsAndTheirDotNetVersion) {
    $appName = $app.Name.substring($vd.Name.lastIndexOf("/"))
    $id = $container.id + $appName
    discovered $id $prototype.type
    inspectedProperty $id "physicalPath" $app.Path
    inspectedProperty $id "websiteName" $website
    inspectedProperty $id "applicationPoolName" $app.AppPoolId

    $virtualDirectory = "$($app.Name)/".toLower()
    $dotNetVersion = $virtualDirsAndTheirDotNetVersion[$virtualDirectory]
    inspectedProperty $id "dotNetVersion" $dotNetVersion

    inspectedItem $id
}

$virtualDirsAndTheirDotNetVersion = getDotNetVersionForVirtualDirectories $container.dotNetFrameworkInstallationPath

$websites = Get-WmiObject -Namespace "ROOT\MicrosoftIISv2" -Class "IIsWebServerSetting"
if($websites) {
    foreach ($ws in $websites) {
        $virtualDirs = Get-WmiObject IIsWebVirtualDirSetting -Namespace "ROOT\MicrosoftIISv2" | Where-Object { $_.Name -like "$($ws.Name)/*" }
        if ($virtualDirs) {
            foreach ($vds in $virtualDirs) {
                $vd = Get-WmiObject IIsWebVirtualDir -Namespace "ROOT\MicrosoftIISv2" | Where-Object { $_.Name -eq $vds.Name }
                if ($vd.AppGetStatus().ReturnValue -ne 2) {
                   inspectApplication $ws.serverComment $vds $virtualDirsAndTheirDotNetVersion
                }
            }
        }
    }
}
