/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.ExtensiblePowerShellDeployed;
import com.xebialabs.deployit.plugin.powershell.SecurePowerShellDeploymentStep;
import java.util.Map;
import java.util.Set;

@Metadata(virtual=true, description="Base class for all extensible IIS deployed resource configuration items.")
public class SecureExtensiblePowerShellDeployed
extends ExtensiblePowerShellDeployed {
    protected boolean addStep(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb, Set<String> options) {
        if (!Strings.isNullOrEmpty((String)scriptPath)) {
            SecurePowerShellDeploymentStep step = this.createSecureStep(ctx, delta, order, scriptPath, verb, options);
            if (operation == null) {
                ctx.addStep((Step)step);
            } else {
                ctx.addStepWithCheckpoint((Step)step, delta, operation);
            }
            return true;
        }
        return false;
    }

    SecurePowerShellDeploymentStep createSecureStep(DeploymentPlanningContext ctx, Delta delta, int order, String scriptPath, String verb, Set<String> options) {
        Map vars = this.getVars(delta.getPrevious(), ctx.getDeployedApplication(), options);
        String description = this.getDescription(verb);
        SecurePowerShellDeploymentStep step = new SecurePowerShellDeploymentStep((HostContainer)this.getContainer(), (Deployed<?, ?>)this, scriptPath, vars, order, description);
        step.setUploadArtifactData(options.contains("uploadArtifactData"));
        if (options.contains("uploadClasspathResources")) {
            step.setClasspathResources(Lists.newArrayList((Iterable)this.getClasspathResources()));
        }
        return step;
    }
}

