/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.FileUploader;
import com.xebialabs.deployit.plugin.jbossas.step.TwiddleProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwiddleStep {
    private transient OverthereConnection remoteConn;
    private transient OverthereFile remoteWorkingDir;
    private final HostContainer container;
    private final String scriptTemplatePath;
    protected transient InspectionExecutionContext ctx;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public TwiddleStep(HostContainer hostContainer, String string) {
        this.container = hostContainer;
        this.scriptTemplatePath = (String)Preconditions.checkNotNull((Object)string, (Object)"scriptTemplatePath is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(InspectionExecutionContext inspectionExecutionContext) throws Exception {
        try {
            this.ctx = inspectionExecutionContext;
            String string = this.resolveOsSpecificTemplate();
            String string2 = this.evaluateTemplate(string, this.getVars());
            this.logger.debug(string2);
            OverthereFile overthereFile = this.uploadExecutable(string2, OverthereUtils.getName((String)string));
            CmdLine cmdLine = CmdLine.build((String[])new String[]{overthereFile.getPath()});
            TwiddleProcessOutputHandler twiddleProcessOutputHandler = new TwiddleProcessOutputHandler();
            MultipleOverthereProcessOutputHandler multipleOverthereProcessOutputHandler = MultipleOverthereProcessOutputHandler.multiHandler((OverthereProcessOutputHandler[])new OverthereProcessOutputHandler[]{new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)inspectionExecutionContext), twiddleProcessOutputHandler});
            inspectionExecutionContext.logOutput("Executing " + overthereFile.getPath() + " on host " + this.container.getHost());
            int n = this.getRemoteConnection().execute((OverthereProcessOutputHandler)multipleOverthereProcessOutputHandler, cmdLine);
            if (n == 0) {
                this.doHandle(twiddleProcessOutputHandler);
                Step.Result result = Step.Result.Success;
                return result;
            }
            Step.Result result = Step.Result.Fail;
            return result;
        }
        finally {
            this.disconnect();
        }
    }

    protected void disconnect() {
        if (this.remoteConn != null) {
            this.remoteConn.close();
        }
        this.remoteWorkingDir = null;
        this.remoteConn = null;
        this.ctx = null;
    }

    protected Map<String, Object> getVars() {
        return Collections.emptyMap();
    }

    protected void doHandle(TwiddleProcessOutputHandler twiddleProcessOutputHandler) {
    }

    private String resolveOsSpecificTemplate() {
        String string = this.scriptTemplatePath;
        if (this.scriptTemplatePath.lastIndexOf(46) == -1) {
            OperatingSystemFamily operatingSystemFamily = this.container.getHost().getOs();
            string = string + operatingSystemFamily.getScriptExtension();
        }
        if (!this.classpathResourceExists(string)) {
            throw new IllegalArgumentException("Resource " + string + " not found in classpath");
        }
        return string;
    }

    private String evaluateTemplate(String string, Map<String, Object> map) {
        Configuration configuration = ConfigurationHolder.getConfiguration();
        try {
            Template template = configuration.getTemplate(string);
            StringWriter stringWriter = new StringWriter();
            template.createProcessingEnvironment(map, (Writer)stringWriter, (ObjectWrapper)new CiAwareObjectWrapper((FileUploader)new WorkingFolderUploader())).process();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        catch (TemplateException templateException) {
            this.logger.error("evaluate Template error", (Throwable)templateException);
            throw new RuntimeException(templateException);
        }
    }

    private OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.container.getHost().getConnection();
        }
        return this.remoteConn;
    }

    private OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile overthereFile = this.getRemoteConnection().getTempFile("jboss_plugin", ".tmp");
            overthereFile.mkdir();
            this.remoteWorkingDir = overthereFile;
        }
        return this.remoteWorkingDir;
    }

    private OverthereFile uploadExecutable(String string, String string2) {
        OverthereFile overthereFile = this.getRemoteWorkingDirectory().getFile(string2);
        OverthereUtils.write((byte[])string.getBytes(), (OverthereFile)overthereFile);
        overthereFile.setExecutable(true);
        return overthereFile;
    }

    private boolean classpathResourceExists(String string) {
        return Thread.currentThread().getContextClassLoader().getResource(string) != null;
    }

    public HostContainer getContainer() {
        return this.container;
    }

    private class WorkingFolderUploader
    implements FileUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();

        private WorkingFolderUploader() {
        }

        public String upload(OverthereFile overthereFile) {
            if (this.uploadedFiles.containsKey(overthereFile.getName())) {
                return this.uploadedFiles.get(overthereFile.getName());
            }
            this.uploadedFiles.put(overthereFile.getName(), overthereFile.getPath());
            return overthereFile.getPath();
        }
    }
}

