import sys
import re
import traceback
from java.util import Map
from java.util import List
from com.xebialabs.deployit.plugin.jbossdm.exception import CliScriptExit

debugCommandLoggingEnabled = False

class CommandBuilder:
    def __init__(self, deployed, basicCmd):
        self.deployed = deployed
        self.cmd = basicCmd

    def add(self, prop, attr):
        propVal = self.deployed.getProperty(prop)
        if isinstance(propVal, bool):
            if propVal:
                propVal = "true"
            else:
                propVal = "false"
        if propVal is not None:
            self.cmd = '%s %s="%s"' % (self.cmd, attr, str(propVal))
        return self

    def addIfNotBlank(self, prop, attr):
        propVal = self.deployed.getProperty(prop)
        if propVal and len(propVal.strip()) > 0:
            self.cmd = '%s %s="%s"' % (self.cmd, attr, propVal)
        return self

    def addIfNotDefaultIntValue(self, prop, attr):
        propVal = self.deployed.getProperty(prop)
        if propVal > 0:
            self.cmd = "%s %s=%s" % (self.cmd, attr, propVal)
        return self

def joinList(delimiter, list):
    return delimiter.join(str(x) for x in list)

def logErrorAndExit(msg):
    logError(msg)
    logError(joinList("\n",traceback.extract_stack()))
    raise CliScriptExit(msg)

def logOutputAndExit(msg):
    logOutput(msg)
    raise CliScriptExit(msg)

def logError(msg):
    step.ctx.logError(str(msg))

def logOutput(msg):
    step.ctx.logOutput(str(msg))

def checkResultForErrors(r):
    if isinstance(r, Map):
        if r["outcome"] == "failed":
            logErrorAndExit(str(r["failure-description"]))
        elif len(r.keySet()) == 1:
            firstKey = r.keySet().iterator().next()
            if firstKey.startswith('JBAS'):
                logErrorAndExit(str(r[firstKey]))
        elif not r.containsKey('outcome'):
            logErrorAndExit("Can not handle processing of object %s " % str(r))
    elif isinstance(r, List):
        for i in r:
            checkResultForErrors(i)
    elif r:
        if (re.search("JBAS[0-9]+", r)):
            logErrorAndExit(r)

def executeCmd(cmd, exitOnFailure=True):
    if debugCommandLoggingEnabled:
        logOutput("Executing command:\n " + cmd)
    try:
        r = step.executeCliCommand(cmd)
    except:
        logErrorAndExit("Failed to execute command. Error %s with message %s " % (sys.exc_info()[0], sys.exc_info()[1]))

    if debugCommandLoggingEnabled:
        logOutput("Result:\n " + str(r))

    if exitOnFailure and r:
        checkResultForErrors(r)

    if r and isinstance(r, List):
        r = [i for i in r if i]
        if len(r) == 1:
            r = r[0]

    return r

def uploadFile(file, targetName):
    return step.uploadToWorkingDirectory(file, targetName)

def targetServerGroups(undeployment=False):
    return container.getTargetServerGroup(undeployment)

def multiSpaceDelimitedLineToList(line):
    if not line:
        return []
    line = line.strip()
    values = []
    for token in line.split(" "):
        if len(token.strip()) > 0:
            values.append(token.strip())
    return values

def discovered(container, name, type):
    return step.discovered("%s/%s" % (container.id,name), type)

def prependProfilePath(cmd):
    if str(container.mode) == "DOMAIN":
        return "/profile=%s%s" %(container.profile, cmd)
    return cmd

def toString(propVal):
    if isinstance(propVal, bool):
        if propVal:
            propVal = "true"
        else:
            propVal = "false"
    else:
        propVal = str(propVal)
    return propVal


def getReleaseVersion():
    return executeCmd("/:read-attribute(name=release-version)", False)["result"]

