package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;

import static com.google.common.collect.FluentIterable.from;

public abstract class LoadBalancerDeployed extends BaseDeployed<LoadBalancerDeployable, LoadBalancer> {

    protected List<Container> affectedServers = new ArrayList<>();
    protected Deltas affectedDeltas;

    public LoadBalancerDeployed() {
    }

    public LoadBalancerDeployed(LoadBalancer loadBalancer, Container affectedServer, Deltas affectedDeltas) {
        super(new LoadBalancerDeployable(), loadBalancer);
        this.affectedServers.add(affectedServer);
        this.affectedDeltas = affectedDeltas;
    }

    public LoadBalancer getLoadBalancer() {
        return getContainer();
    }

    public List<Container> getAffectedServers() {
        return affectedServers;
    }

    public Deltas getAffectedDeltas() {
        return affectedDeltas;
    }

    void combine(LoadBalancerDeployed other) {
        Preconditions.checkState(getLoadBalancer().equals(other.getLoadBalancer()), "Deployeds must belong to same load balancer.");
        affectedServers.addAll(
            from(other.getAffectedServers()).filter(new Predicate<Container>() {
                @Override
                public boolean apply(Container input) {
                    return !affectedServers.contains(input);
                }
            }).toList());
        final List<Delta> deltas = new ArrayList<>(affectedDeltas.getDeltas());
        deltas.addAll(
            from(other.getAffectedDeltas().getDeltas()).filter(new Predicate<Delta>() {
                @Override
                public boolean apply(Delta newDelta) {
                    return !deltas.contains(newDelta);
                }
            }).toList());
        affectedDeltas = new Deltas(deltas);
    }

}