package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

/**
 * Delta processed by orchesttrator.
 * Used as a marker to pass that information from orchestrator to contributor.
 */
public class ProcessedDelta implements Delta {

    private Delta original;

    public ProcessedDelta(Delta original) {
        this.original = original;
    }

    @Override
    public Operation getOperation() {
        return original.getOperation();
    }

    @Override
    public Deployed<?, ?> getPrevious() {
        return original.getPrevious();
    }

    @Override
    public Deployed<?, ?> getDeployed() {
        return original.getDeployed();
    }

    @Override
    public List<String> getIntermediateCheckpoints() {
        return original.getIntermediateCheckpoints();
    }

}
