/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.lb.planning.ContainerCollector;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.LoadBalancerDelta;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.LoadBalancerDeployed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class LoadBalancerComputedDeltas {
    final List<Delta> deltasToPass;
    final List<LoadBalancerDeployed> deployedsForDisable;
    final List<LoadBalancerDeployed> deployedsForEnable;

    public LoadBalancerComputedDeltas(List<Delta> deltasToPass, List<LoadBalancerDeployed> deployedsForDisable, List<LoadBalancerDeployed> deployedsForEnable) {
        this.deltasToPass = deltasToPass;
        this.deployedsForDisable = deployedsForDisable;
        this.deployedsForEnable = deployedsForEnable;
    }

    public List<Delta> getDeltasToPass() {
        return this.deltasToPass;
    }

    public List<Delta> getDeltasForDisable() {
        return this.deployedsToDeltas(this.deployedsForDisable);
    }

    public List<Delta> getDeltasForEnable() {
        return this.deployedsToDeltas(this.deployedsForEnable);
    }

    public List getAffectedServerNameForDisable() {
        return this.getAffectedServerNames(this.deployedsForDisable);
    }

    public List getAffectedServerNameForEnable() {
        return this.getAffectedServerNames(this.deployedsForEnable);
    }

    public List<String> getPassedContainerNames() {
        return FluentIterable.from(ContainerCollector.collectContainers(new Deltas(this.deltasToPass), Container.class)).transform((Function)new Function<Container, String>(){

            public String apply(Container input) {
                return input.getName();
            }
        }).toList();
    }

    private List getAffectedServerNames(List<LoadBalancerDeployed> loadBalancerDeployeds) {
        HashSet<String> affectedServers = new HashSet<String>();
        for (LoadBalancerDeployed loadBalancerDeployed : loadBalancerDeployeds) {
            for (Container container : loadBalancerDeployed.getAffectedServers()) {
                affectedServers.add(container.getName());
            }
        }
        ArrayList affectedServersList = new ArrayList(affectedServers);
        Collections.sort(affectedServersList);
        return affectedServersList;
    }

    private ImmutableList<Delta> deployedsToDeltas(List<LoadBalancerDeployed> deployeds) {
        return FluentIterable.from(deployeds).transform((Function)new Function<LoadBalancerDeployed, Delta>(){

            public Delta apply(LoadBalancerDeployed deployed) {
                return new LoadBalancerDelta(deployed);
            }
        }).toList();
    }
}

