/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.planning.orchestrator;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.lb.planning.orchestrator.LoadBalancerDeployable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class LoadBalancerDeployed
extends BaseDeployed<LoadBalancerDeployable, LoadBalancer> {
    protected List<Container> affectedServers = new ArrayList<Container>();
    protected Deltas affectedDeltas;

    public LoadBalancerDeployed() {
    }

    public LoadBalancerDeployed(LoadBalancer loadBalancer, Container affectedServer, Deltas affectedDeltas) {
        super((Deployable)new LoadBalancerDeployable(), (Container)loadBalancer);
        this.affectedServers.add(affectedServer);
        this.affectedDeltas = affectedDeltas;
    }

    public LoadBalancer getLoadBalancer() {
        return (LoadBalancer)this.getContainer();
    }

    public List<Container> getAffectedServers() {
        return this.affectedServers;
    }

    public Deltas getAffectedDeltas() {
        return this.affectedDeltas;
    }

    void combine(LoadBalancerDeployed other) {
        Preconditions.checkState((boolean)this.getLoadBalancer().equals((Object)other.getLoadBalancer()), (Object)"Deployeds must belong to same load balancer.");
        this.affectedServers.addAll((Collection<Container>)FluentIterable.from(other.getAffectedServers()).filter((Predicate)new Predicate<Container>(){

            public boolean apply(Container input) {
                return !LoadBalancerDeployed.this.affectedServers.contains(input);
            }
        }).toList());
        final ArrayList deltas = new ArrayList(this.affectedDeltas.getDeltas());
        deltas.addAll(FluentIterable.from((Iterable)other.getAffectedDeltas().getDeltas()).filter((Predicate)new Predicate<Delta>(){

            public boolean apply(Delta newDelta) {
                return !deltas.contains(newDelta);
            }
        }).toList());
        this.affectedDeltas = new Deltas(deltas);
    }
}

