package com.xebialabs.deployit.plugin.netscaler;

import java.util.Collection;
import com.google.common.base.Strings;

import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;

import static com.google.common.collect.Lists.newArrayList;

public class NetScalerParameters extends Parameters {

    @Property(label = "NetScaler service group", category = "Service Group", required = true)
    private String serviceGroup;

    @Property(label = "NetScaler service name", category = "Service Group", required = true)
    private String serviceGroupName;

    @Property(label = "NetScaler service port", category = "Service Group", required = true)
    @Range(minimum = 1, maximum = 65535)
    private Integer serviceGroupPort;

    public String getServiceGroup() {
        return serviceGroup;
    }

    public String getServiceGroupName() {
        return serviceGroupName;
    }

    public Integer getServiceGroupPort() {
        return serviceGroupPort;
    }

    private boolean isServiceGroup() {
        return !Strings.nullToEmpty(serviceGroup).trim().isEmpty();
    }

    public Collection<? extends NetScalerItem> getItems() {
        if (isServiceGroup()) {
            return newArrayList(new ServiceGroup(serviceGroup, serviceGroupName, serviceGroupPort));
        }
        return newArrayList();
    }
}
