/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.netscaler;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.deployit.plugin.netscaler.NetScalerItem;
import com.xebialabs.deployit.plugin.netscaler.ServiceGroup;
import java.util.Collection;

public class NetScalerParameters
extends Parameters {
    @Property(label="NetScaler service group", category="Service Group", required=true)
    private String serviceGroup;
    @Property(label="NetScaler service name", category="Service Group", required=true)
    private String serviceGroupName;
    @Property(label="NetScaler service port", category="Service Group", required=true)
    @Range(minimum=1, maximum=65535)
    private Integer serviceGroupPort;

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public String getServiceGroupName() {
        return this.serviceGroupName;
    }

    public Integer getServiceGroupPort() {
        return this.serviceGroupPort;
    }

    private boolean isServiceGroup() {
        return !Strings.nullToEmpty((String)this.serviceGroup).trim().isEmpty();
    }

    public Collection<? extends NetScalerItem> getItems() {
        if (this.isServiceGroup()) {
            return Lists.newArrayList((Object[])new ServiceGroup[]{new ServiceGroup(this.serviceGroup, this.serviceGroupName, this.serviceGroupPort)});
        }
        return Lists.newArrayList();
    }
}

