/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.netscaler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.deployit.plugin.generic.step.WaitStep;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.netscaler.NetScalerItem;
import com.xebialabs.deployit.plugin.netscaler.NetScalerParameters;
import com.xebialabs.deployit.plugin.netscaler.NetScalerScriptParameters;
import com.xebialabs.deployit.plugin.netscaler.ServerOrService;
import com.xebialabs.deployit.plugin.netscaler.ServiceGroup;
import com.xebialabs.deployit.plugin.netscaler.step.CliScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.NESTED, virtual=false, description="A Citrix NetScaler LoadBalancer")
public class NetScaler
extends LoadBalancer {
    public static final String CONTAINER_NS_SHUTDOWN_DELAY = "netscalerShutdownDelay";
    static final String CONTAINER_NS_ADDRESS = "netscalerAddress";
    static final String SERVICE_GROUP = "netscalerServiceGroup";
    static final String SERVICE_GROUP_SERVICE_NAME = "netscalerServiceGroupName";
    static final String SERVICE_GROUP_SERVICE_PORT = "netscalerServiceGroupPort";
    @Property(defaultValue="8", hidden=true)
    private int disableServersOrder = 8;
    @Property(defaultValue="netscaler/disable-server.cli.ftl", hidden=true)
    private String disableServersScript = "netscaler/disable-server.cli.ftl";
    @Property(defaultValue="94", hidden=true)
    private int enableServersOrder = 94;
    @Property(defaultValue="netscaler/enable-server.cli.ftl", hidden=true)
    private String enableServersScript = "netscaler/enable-server.cli.ftl";
    @Property(defaultValue="netscaler/run-script.cli.ftl", hidden=true)
    private String runScript = "netscaler/run-script.cli.ftl";
    @Property(required=false, description="The amount of seconds to wait before the servers are disabled in the load balancer", defaultValue="0")
    @Range(minimum=0)
    private int defaultShutdownDelay;
    @Property(asContainment=true)
    private Host host;
    @Property(hidden=true, defaultValue="source")
    private String sourceCommand;
    private static final Logger logger = LoggerFactory.getLogger(NetScaler.class);

    public void stopTraffic(Deltas deltas, DeploymentPlanningContext ctx, Set<Container> serversToDisable) {
        ArrayList nsItems;
        if (!this.getServiceGroups(deltas, serversToDisable).isEmpty()) {
            nsItems = Lists.newArrayList(this.getServiceGroups(deltas, serversToDisable));
            logger.info("Loadbalancing service groups: {}", (Object)nsItems);
        } else {
            nsItems = this.containersToNetScalerItems(serversToDisable);
            this.validateAllServersHaveNetScalerAddress(nsItems);
            logger.info("Loadbalancing servers/services : {}", (Object)nsItems);
        }
        ctx.addStep((Step)new CliScriptExecutionStep(this.disableServersOrder, this.sourceCommand, this.disableServersScript, (HostContainer)this, this.createContext(nsItems), String.format("Disable servers %s in %s", new Object[]{serversToDisable, this})));
        ctx.addStep((Step)new WaitStep(this.disableServersOrder, this.determineMaxWait(nsItems), this.toString(), "disable servers"));
    }

    public void startTraffic(Deltas deltas, DeploymentPlanningContext ctx, Set<Container> serversToEnable) {
        Collection<NetScalerItem> services;
        if (!this.getServiceGroups(deltas, serversToEnable).isEmpty()) {
            services = this.getServiceGroups(deltas, serversToEnable);
        } else {
            services = this.containersToNetScalerItems(serversToEnable);
            this.validateAllServersHaveNetScalerAddress(services);
        }
        ctx.addStep((Step)new CliScriptExecutionStep(this.enableServersOrder, this.sourceCommand, this.enableServersScript, (HostContainer)this, this.createContext(services), String.format("Enable servers %s in %s", new Object[]{serversToEnable, this})));
    }

    @VisibleForTesting
    Collection<NetScalerItem> containersToNetScalerItems(Set<Container> serversToDisable) {
        return Lists.newArrayList((Iterable)Collections2.transform(serversToDisable, (Function)new Function<Container, NetScalerItem>(){

            public NetScalerItem apply(Container input) {
                return new ServerOrService(input, NetScaler.this.defaultShutdownDelay);
            }
        }));
    }

    @VisibleForTesting
    List<NetScalerItem> getServiceGroups(Deltas deltas, final Set<Container> affectedServers) {
        return Lists.newArrayList((Iterable)FluentIterable.from((Iterable)deltas.getDeltas()).transform((Function)new Function<Delta, Deployed>(){

            public Deployed apply(Delta input) {
                return input.getOperation() == Operation.DESTROY ? input.getPrevious() : input.getDeployed();
            }
        }).filter((Predicate)new Predicate<Deployed>(){

            public boolean apply(Deployed input) {
                String serviceGroup = Strings.nullToEmpty((String)((String)input.getProperty(NetScaler.SERVICE_GROUP))).trim();
                return !serviceGroup.isEmpty() && affectedServers.contains(input.getContainer()) && !serviceGroup.startsWith("{{");
            }
        }).transform((Function)new Function<Deployed, NetScalerItem>(){

            public NetScalerItem apply(Deployed input) {
                return new ServiceGroup(input);
            }
        }));
    }

    @VisibleForTesting
    int determineMaxWait(Collection<NetScalerItem> servers) {
        int waitTime = 0;
        for (NetScalerItem server : servers) {
            int serverTime = server.getDelay();
            waitTime = serverTime > waitTime ? serverTime : waitTime;
        }
        return waitTime;
    }

    private Map<String, Object> createContext(Collection<? extends NetScalerItem> servers) {
        return ImmutableMap.of((Object)"loadBalancer", (Object)((Object)this), (Object)"servers", servers);
    }

    private void validateAllServersHaveNetScalerAddress(Collection<NetScalerItem> servers) {
        for (NetScalerItem server : servers) {
            server.getAddress();
        }
    }

    public Host getHost() {
        return this.host;
    }

    public void setDefaultShutdownDelay(int defaultShutdownDelay) {
        this.defaultShutdownDelay = defaultShutdownDelay;
    }

    @ControlTask(label="Enable servers", parameterType="netscaler.NetScalerParameters")
    public List<Step> enableService(NetScalerParameters parameters) {
        return Lists.newArrayList((Object[])new Step[]{new CliScriptExecutionStep(this.enableServersOrder, this.sourceCommand, this.enableServersScript, (HostContainer)this, this.createContext(parameters.getItems()), String.format("Enable services %s in %s", new Object[]{parameters.getItems(), this}))});
    }

    @ControlTask(label="Disable servers", parameterType="netscaler.NetScalerParameters")
    public List<Step> disableService(NetScalerParameters parameters) {
        return Lists.newArrayList((Object[])new Step[]{new CliScriptExecutionStep(this.disableServersOrder, this.sourceCommand, this.disableServersScript, (HostContainer)this, this.createContext(parameters.getItems()), String.format("Disable services %s in %s", new Object[]{parameters.getItems(), this}))});
    }

    @ControlTask(label="Execute NetScaler script", parameterType="netscaler.NetScalerScriptParameters")
    public List<Step> runScript(NetScalerScriptParameters parameters) {
        return Lists.newArrayList((Object[])new Step[]{new CliScriptExecutionStep(this.enableServersOrder, this.sourceCommand, this.runScript, (HostContainer)this, (Map<String, Object>)ImmutableMap.of((Object)"script", (Object)parameters.getNetScalerScript()), "Run NetScaler script")});
    }
}

