import types
import sys

def toWlsCommandArgs(obj):
    args = {}
    props = obj.getExposedProperties()
    for key, value in props.items():
        if value != None and isinstance(value, DictionaryObject) == False:
            args[key] = value
    return args

def findAllNestedObjects(obj):
    nestedObjects = {}
    props = obj.getExposedProperties()
    for propName, propValue in props.items():
        if isinstance(propValue, DictionaryObject) == True:
            nestedObjects[propName] = propValue
    return nestedObjects


def setNestedPropertiesRecursively(objectName, initialPath, nestedObjects, setfunction):
    for nestedObjName in nestedObjects.keys():
        nestedObj = nestedObjects[nestedObjName]
        print 'setting properties on object = %s with nestedProp = %s' %(objectName, nestedObjName)

        if hasattr(nestedObj, "id"):
            #it's a CI reference(like errorQueue in a Queue)
            name = nestedObj.name
        else:
            simpleProperties = nestedObj.getExposedProperties()
            if len(simpleProperties) != 0:
                nestedObjectPath = initialPath + "/" + nestedObjName + "/" + objectName
                print 'cd to %s' %(nestedObjectPath)
                cd(nestedObjectPath)
                for propName, propValue in simpleProperties.items():
                    print 'setting %s in %s to %s' %(propName, nestedObjName, propValue)
                    if propValue is not None:
                        if propValue == 0 or propValue == 1:
                            booleanAwareSet(propName, propValue, setfunction)
                        else:
                            setfunction(propName, propValue)

            objectTypeProperties = findAllNestedObjects(nestedObj)
            if len(objectTypeProperties) != 0:
                initialPath = initialPath + "/" + nestedObjName + "/" + objectName
                setNestedPropertiesRecursively(nestedObjName, initialPath, objectTypeProperties)

def booleanAwareSet(key, value, setfunction):
    if value == 0:
        boolValue = "false"
    elif value == 1:
        boolValue = "true"
    else:
        boolValue = value
    try:
        setfunction(key, boolValue)
    except:
        setfunction(key, value)

def createOrUpdateJmsModuleWithTarget(jmsModuleName, containerObjectName):
    existingModule = getMBean('/JMSSystemResources/' + jmsModuleName)
    if existingModule is None:
        print "Creating JMS Module " + jmsModuleName
        cd('/')
        cmo.createJMSSystemResource(jmsModuleName)
        print 'JmsModule created'
    cd('/JMSSystemResources/' + jmsModuleName)
    newTargets = []
    for t in get('Targets'):
        newTargets.append(t)
    newTargets.append(ObjectName(containerObjectName))
    set('Targets', jarray.array(newTargets, ObjectName))
    print "target %s added to jmsModule %s targets" %(containerObjectName, jmsModuleName)

def createOrUpdateSubDeploymentWithTarget(jmsModuleName, subDeploymentName, jmsServerObjectName):
    subDeploymentPath = "/JMSSystemResources/%s/SubDeployments/%s" % (jmsModuleName, subDeploymentName)
    print "subDeploymentPath",subDeploymentPath

    existingSubDeployment = getMBean(subDeploymentPath)
    if existingSubDeployment is None:
        print "Creating Subdeployment %s in Jms Module %s" %(subDeploymentName, jmsModuleName)
        cd('/JMSSystemResources/' + jmsModuleName)
        cmo.createSubDeployment(subDeploymentName)
    cd(subDeploymentPath)
    newTargets = []
    for t in get('Targets'):
        newTargets.append(t)
    newTargets.append(ObjectName(jmsServerObjectName))
    print 'setting targets of subdeployment: %s' %(newTargets)
    set('Targets', jarray.array(newTargets, ObjectName))
    print "target %s added to subDeployment %s targets" %(jmsServerObjectName, subDeploymentName)


def toWlsContainer(container):
    wlsContainer = container
    if hasattr(wlsContainer, 'server'):
        #wlsContainer is a jmsServer, so get the server from it
        wlsContainer =  container.server
    return wlsContainer

def overrideWithWarning(key, value):
    if get(key) != value:
        print "WARNING: Overriding property %s: old value: %s new value: %s" % (key, get(key), value)
    set(key, value)


def getRemainingTargets(deployed, currentTargets):
    containerTarget = ObjectName(deployed.container.objectName)
    newTargets = []
    for t in currentTargets:
        if t != containerTarget:
            newTargets.append(t)
    return newTargets

def isEmpty(value):
    return value == None or value == "" or value == "null"

def saveAndActivate():
    save()
    activate(block="true")

def connectAndEdit():
    edit()
    startEdit()

def saveAndExit(exitcode = 0):
    saveAndActivate()
    sys.exit(exitcode)

def discardAndExit(exitcode = 1):
    cancelEdit('y')
    sys.exit(exitcode)

def exists(path):
    m = getMBean(path)
    return m is not None

def getArrayFromPyArray(pyArray):
    arr = []
    for eachObj in pyArray:
        arr.append(eachObj)
    return arr
# Functions invoked by the PythonScriptStep

def connectToAdminServer():
    script = sys.argv.pop(0)
    user = sys.argv.pop(0)
    url = sys.argv.pop(0)
    password = getPasswordFromFile(script)

    print "Connecting to WebLogic %s as user %s" %(url, user)
    connect(user, password, url)

def connectFromDaemon():
   connectToAdminServer();

def connectFromStandAloneScript():
    connectToAdminServer()

def getPasswordFromFile(script_path):
    file_path = getPasswordFilePath(script_path, "wlst.pass")
    passwd = readPassword(file_path)
    removePasswordFile(file_path)
    return passwd

def disconnectFromAdminServer():
    disconnect('true')
    exit('y', 0)

def disconnectFromDaemon():
    disconnectFromAdminServer()

def disconnectFromStandAloneScript():
    disconnectFromAdminServer()

def runScriptFromDaemon(scriptPath):
    cd('/')
    execfile(scriptPath)

def disconnectFromDaemonForError():
    undo(defaultAnswer='y', unactivatedChanges='true')
    stopEdit('y')

def readPassword(file_path):
    file = open(file_path, "r")
    passwd = file.read().strip()
    file.close()
    return passwd

def getPasswordFilePath(script_path, name):
    dir_path = os.path.dirname(script_path)
    return os.path.join(dir_path, name)

def removePasswordFile(path):
    try:
        os.remove(path)
    except OSError:
        pass