/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, virtual=true, description="A machine that runs middleware, on which scripts can be executed, etc.")
public class Host
extends BaseConfigurationItem
implements Container {
    @Property(description="Protocol to use when connecting to this host", hidden=true)
    private String protocol;
    @Property(description="Operating system")
    private OperatingSystemFamily os;
    @Property(description="Directory into which temporary files are stored. Will be cleaned up when the connection is closed.", required=false)
    private String temporaryDirectoryPath;
    private static Logger logger = LoggerFactory.getLogger(Host.class);

    public OverthereConnection getConnection() {
        logger.debug("Using connection protocol {}", (Object)this.protocol);
        return Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.getConnectionOptions());
    }

    private ConnectionOptions getConnectionOptions() {
        ConnectionOptions options = new ConnectionOptions();
        this.setConnectionOption(options, "os", this.getOs());
        if (!Strings.nullToEmpty((String)this.getTemporaryDirectoryPath()).trim().isEmpty()) {
            this.setConnectionOption(options, "tmp", this.getTemporaryDirectoryPath());
        }
        for (Map.Entry prop : this.getSyntheticProperties().entrySet()) {
            this.setConnectionOption(options, (String)prop.getKey(), prop.getValue());
        }
        return options;
    }

    private void setConnectionOption(ConnectionOptions options, String key, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting connection option {}: {}", (Object)key, value);
        }
        options.set(key, value);
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily os) {
        this.os = os;
    }

    public String getTemporaryDirectoryPath() {
        return this.temporaryDirectoryPath;
    }

    public void setTemporaryDirectoryPath(String temporaryDirectoryPath) {
        this.temporaryDirectoryPath = temporaryDirectoryPath;
    }
}

