package com.xebialabs.deployit.plugin.policy.serialization

import com.thoughtworks.xstream.converters.MarshallingContext
import com.thoughtworks.xstream.io.HierarchicalStreamWriter
import com.xebialabs.deployit.core.rest.xml.TaskWithBlockWriter
import com.xebialabs.deployit.engine.api.execution.{PhaseContainerState, TaskWithBlock}
import com.xebialabs.xltype.serialization.xstream.Converters

class ArchivedTaskConverter extends TaskWithBlockWriter {
  override def writePhaseContainer(writer: HierarchicalStreamWriter, context: MarshallingContext, task: TaskWithBlock): Unit = {
    writer.startNode("block")
    Converters.writePhaseContainer(task.getBlock.asInstanceOf[PhaseContainerState], writer, context, true)
    writer.endNode
  }
}
