#
import os
import zipfile

from com.thoughtworks.xstream import XStream
from com.xebialabs.xltype.serialization.xstream import XStreamReaderWriter
from com.xebialabs.deployit.core.rest.xml import ArchivedTaskWriter
from com.xebialabs.deployit.core.rest.xml import StepStateWriter
from com.xebialabs.deployit.task.archive import ArchivedTask


class TaskExporter:
    def __init__(self):
        self.writer = XStream(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER)
        self.writer.registerConverter(ArchivedTaskWriter())
        self.writer.registerConverter(StepStateWriter())
        self.writer.aliasType("task", ArchivedTask)

    def export(self, tasks, archive_path):
        if not archive_path:
            raise Exception("Property 'archivePath' not defined, please define a valid path for the export.")

        archive_dir = os.path.dirname(archive_path)
        if not os.path.exists(archive_dir):
            os.makedirs(archive_dir)

        archive_file = zipfile.ZipFile(archive_path, "w", zipfile.ZIP_DEFLATED)
        try:
            for task in tasks:
                task_xml = self.writer.toXML(task._delegate)
                task_filename = "%04d/%02d/%02d/%s.xml" % (task.startDate.getYear(), task.startDate.getMonthOfYear(), task.startDate.getDayOfMonth(), str(task.id))
                archive_file.writestr(task_filename, task_xml)
        finally:
            archive_file.close()
