/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.policy;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.xebialabs.deployit.core.rest.xml.ArchivedTaskWriter;
import com.xebialabs.deployit.core.rest.xml.StepStateWriter;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.python.core.PyInstance;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.runtime.BoxedUnit;

public final class TaskExporter$ {
    public static final TaskExporter$ MODULE$;

    static {
        new TaskExporter$();
    }

    public void export(Collection<PyInstance> tasks, String archivePath) {
        XStream writer = new XStream((HierarchicalStreamDriver)XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER);
        writer.registerConverter((Converter)new ArchivedTaskWriter());
        writer.registerConverter((Converter)new StepStateWriter());
        writer.aliasType("task", ArchivedTask.class);
        if (archivePath == null) {
            throw new Exception("Property 'archivePath' not defined, please define a valid path for the export.");
        }
        Path archivedTaskPath = Paths.get(archivePath, new String[0]);
        Path archiveDir = archivedTaskPath.getParent();
        Object object = Files.exists(archiveDir, new LinkOption[0]) ? BoxedUnit.UNIT : Files.createDirectories(archiveDir, new FileAttribute[0]);
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(archivedTaskPath.toFile()));
        try {
            ((IterableLike)((WrapAsScala)package$.MODULE$.wrapAll()).collectionAsScalaIterable(tasks).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArchivedTask apply(PyInstance x$1) {
                    return (ArchivedTask)x$1.__getattr__("_delegate").__tojava__(ArchivedTask.class);
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(writer, zip){
                public static final long serialVersionUID = 0L;
                private final XStream writer$1;
                private final ZipOutputStream zip$1;

                public final void apply(ArchivedTask task) {
                    String taskFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".xml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getStartDate().toString("yyyy/MM/dd"), task.getId()}));
                    this.zip$1.putNextEntry(new ZipEntry(taskFileName));
                    this.writer$1.toXML((Object)task, (OutputStream)this.zip$1);
                    this.zip$1.closeEntry();
                }
                {
                    this.writer$1 = writer$1;
                    this.zip$1 = zip$1;
                }
            });
            return;
        }
        finally {
            zip.close();
        }
    }

    private TaskExporter$() {
        MODULE$ = this;
    }
}

