package com.xebialabs.deployit.plugin.policy

import java.util.{HashMap => JHashMap, List => JList, Map => JMap}

import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot._
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.scheduler.ci.StepJob

import scala.beans.BeanProperty
import scala.collection.convert.wrapAll._

@Metadata(virtual = true, root = CONFIGURATION, description = "Base scheduled administrative job which executes a server-side Jython script.")
@PermissionValidator
class JythonStepJob extends StepJob {
  @BeanProperty
  @Property(label = "Description", required = true, description = "Description of this step, as it should appear in generated deployment plans")
  var description: String = _

  @BeanProperty
  @Property(label = "Script", required = true, description = "Path to the Python script to execute (relative to XL Deploy's classpath)")
  var scriptPath: String = _

  override def getSteps(params: JMap[String, String]): JList[Step] = {
    val jythonContext = populateContext(params)
    val stepParameters = Map("order" -> 1, "description" -> getDescription, "script" -> getScriptPath, "jython-context" -> jythonContext)
    List(StepFactoryHelper.newStep("jython", stepParameters))
  }

  private[policy] def populateContext(params: JMap[String, String]): JMap[String, Any] = {
    Map("job" -> this) ++ Option(params).getOrElse(new JHashMap[String, Any]())
  }
}
