/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.AutoFlushingExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PowerShellStep<C extends ExecutionContext>
implements Step<C> {
    private static final String STANDARD_RUNTIME_PATH = "powershell/runtime";
    private PowerShellContainer container;
    private String scriptPath;
    private Map<String, Object> powerShellVars;
    private String description;
    private boolean uploadArtifactData = true;
    private static Logger logger = LoggerFactory.getLogger(PowerShellStep.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.powershell.scripts");

    public PowerShellStep(PowerShellContainer container, String scriptPath, Map<String, Object> powerShellVars, String description) {
        this.container = (PowerShellContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.powerShellVars = (Map)Preconditions.checkNotNull(powerShellVars, (Object)"powerShellVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result doExecute(ExecutionContext ctx) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            OverthereConnection conn;
            block8: {
                Step.Result result;
                conn = this.container.getHost().getConnection();
                try {
                    String finalScript = this.aggregateScript(conn);
                    ScriptUtils.dumpScript((String)OverthereUtils.getName((String)this.scriptPath), (String)finalScript, (Logger)scriptsLogger);
                    OverthereFile uploadedScriptFile = ScriptUtils.uploadScript((OverthereConnection)conn, (String)this.scriptPath, (String)finalScript);
                    int res = this.executePowerShellScript(ctx, conn, uploadedScriptFile);
                    logger.debug("Exit code: {}", (Object)res);
                    if (res != 0) break block8;
                    result = Step.Result.Success;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly((Closeable)conn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)conn);
                return result;
            }
            Step.Result result = Step.Result.Fail;
            Closeables.closeQuietly((Closeable)conn);
            return result;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    protected String aggregateScript(OverthereConnection connection) {
        String convertedVars = PowerShellVarsConverter.javaToPowerShell(connection, this.powerShellVars, this.uploadArtifactData);
        StringBuilder b = new StringBuilder();
        b.append(ScriptUtils.loadScriptDir((String)STANDARD_RUNTIME_PATH));
        b.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
        b.append("# PowerShellVars\n");
        b.append(convertedVars);
        b.append(ScriptUtils.loadScript((String)this.scriptPath));
        return b.toString().replaceAll("\n", "\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executePowerShellScript(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        logger.info("Executing PowerShell script {} on {}", (Object)script, (Object)conn);
        AutoFlushingExecutionContextOverthereProcessOutputHandler handler = new AutoFlushingExecutionContextOverthereProcessOutputHandler(ctx);
        try {
            int n = conn.execute((OverthereProcessOutputHandler)handler, this.container.getScriptCommandLine(script));
            return n;
        }
        finally {
            handler.close();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }
}

