/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.remoting.vars.VarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class PowerShellVarsConverter
extends VarsConverter {
    public static String javaToPowerShell(OverthereConnection connection, Map<String, Object> powershellVars) {
        return PowerShellVarsConverter.javaToPowerShell(connection, powershellVars, true, null);
    }

    public static String javaToPowerShell(OverthereConnection connection, Map<String, Object> powershellVars, boolean uploadArtifactData, ExecutionContext ctx) {
        List<String> powerShellList = PowerShellVarsConverter.javaToPowerShellList(connection, powershellVars, uploadArtifactData, ctx);
        return Joiner.on((String)"\n").join(powerShellList) + "\n";
    }

    static List<String> javaToPowerShellList(OverthereConnection connection, Map<String, Object> powershellVars, boolean uploadArtifactData, ExecutionContext ctx) {
        PowerShellVarsConverter converter = new PowerShellVarsConverter(connection, powershellVars);
        converter.setUploadArtifactData(uploadArtifactData);
        converter.setExecutionContext(ctx);
        return converter.convert();
    }

    private PowerShellVarsConverter(OverthereConnection connection, Map<String, Object> pythonVars) {
        super(connection, pythonVars);
    }

    protected void setNullVariable(String variableName) {
        this.add("$" + variableName + " = $null");
    }

    protected void setBooleanVariable(String variableName, boolean variableValue) {
        this.add("$" + variableName + " = " + PowerShellVarsConverter.toPowerShellBoolean(variableValue));
    }

    protected void setIntegerVariable(String variableName, int variableValue) {
        this.add("$" + variableName + " = " + variableValue);
    }

    protected void setLongVariable(String variableName, long variableValue) {
        this.add("$" + variableName + " = " + variableValue);
    }

    protected void setStringVariable(String variableName, String variableValue) {
        this.add("$" + variableName + " = " + PowerShellVarsConverter.toPowerShellString(variableValue));
    }

    protected void setCollectionOfStringsVariable(String variableName, Collection<?> variableValue) {
        this.add("$" + variableName + " = " + PowerShellVarsConverter.toPowerShellCollectionOfStrings(variableValue));
    }

    protected void startCreateObject(String variableName) {
        this.add("$" + variableName + " = New-Object Object");
    }

    protected void endCreateObject(String variableName) {
    }

    private void setNoteProperty(String objectName, String propertyName, String literalPropertyValue) {
        this.add("$" + objectName + " | Add-Member NoteProperty " + PowerShellVarsConverter.toPowerShellString(propertyName) + " " + literalPropertyValue);
    }

    protected void setNullProperty(String objectName, String propertyName) {
        this.setNoteProperty(objectName, propertyName, "$null");
    }

    protected void setEmptyCollectionProperty(String objectName, String propertyName) {
        this.setNoteProperty(objectName, propertyName, "@()");
    }

    protected void setEmptyMapProperty(String objectName, String propertyName) {
        this.setNoteProperty(objectName, propertyName, "@{}");
    }

    protected void setBooleanProperty(String objectName, String propertyName, boolean propertyValue) {
        this.setNoteProperty(objectName, propertyName, PowerShellVarsConverter.toPowerShellBoolean(propertyValue));
    }

    protected void setIntegerProperty(String objectName, String propertyName, int propertyValue) {
        this.setNoteProperty(objectName, propertyName, Integer.toString(propertyValue));
    }

    protected void setStringProperty(String objectName, String propertyName, String propertyValue) {
        this.setNoteProperty(objectName, propertyName, PowerShellVarsConverter.toPowerShellString(propertyValue));
    }

    protected void setPasswordProperty(String objectName, String propertyName, String propertyValue) {
        this.setNoteProperty(objectName, propertyName, "([System.Text.Encoding]::UTF8.GetString([System.Convert]::FromBase64String(" + PowerShellVarsConverter.toPowerShellString(Base64.encodeBase64String((byte[])propertyValue.getBytes())) + ")))");
    }

    protected void setCollectionOfStringsProperty(String objectName, String propertyName, Collection<?> propertyValue) {
        this.setNoteProperty(objectName, propertyName, PowerShellVarsConverter.toPowerShellCollectionOfStrings(propertyValue));
    }

    protected void setCiReferenceProperty(String objectName, String propertyName, ConfigurationItem propertyValue) {
        this.setNoteProperty(objectName, propertyName, "$" + this.getConfigurationItemVariableName(propertyValue));
    }

    protected void setCollectionOfCiReferencesProperty(String objectName, String propertyName, Collection<ConfigurationItem> propertyValue) {
        ArrayList varRefs = Lists.newArrayList();
        for (ConfigurationItem setItem : propertyValue) {
            varRefs.add("$" + this.getConfigurationItemVariableName(setItem));
        }
        this.setNoteProperty(objectName, propertyName, "@(" + Joiner.on((String)", ").join((Iterable)varRefs) + ")");
    }

    protected void setMapOfStringToStringReferencesProperty(String objectName, String propertyName, Map<String, String> propertyValue) {
        ArrayList entries = Lists.newArrayList();
        for (String key : propertyValue.keySet()) {
            String value = propertyValue.get(key);
            if (value == null) {
                entries.add(PowerShellVarsConverter.toPowerShellString(key) + " = $null");
                continue;
            }
            entries.add(PowerShellVarsConverter.toPowerShellString(key) + " = " + PowerShellVarsConverter.toPowerShellString(value));
        }
        this.setNoteProperty(objectName, propertyName, "@{" + Joiner.on((String)"; ").join((Iterable)entries) + "}");
    }

    protected void createObjectAndSetObjectProperty(String objectName, String propertyName) {
        String embeddedObjectVariableName = this.generateUniqueVariableName();
        this.startCreateObject(embeddedObjectVariableName);
        this.endCreateObject(embeddedObjectVariableName);
        this.setNoteProperty(objectName, propertyName, "$" + embeddedObjectVariableName);
    }

    public static String toPowerShellBoolean(Boolean bool) {
        return bool != false ? "$true" : "$false";
    }

    public static String toPowerShellString(String str) {
        StringBuilder converted = new StringBuilder();
        converted.append("'");
        block3: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\'': {
                    converted.append("''");
                    continue block3;
                }
                default: {
                    converted.append(c);
                }
            }
        }
        converted.append("'");
        return converted.toString();
    }

    public static String toPowerShellCollectionOfStrings(Collection<?> variableValue) {
        Collection encodedStrings = Collections2.transform(variableValue, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return PowerShellVarsConverter.toPowerShellString(input.toString());
            }
        });
        return "@(" + Joiner.on((String)", ").join((Iterable)encodedStrings) + ")";
    }
}

