import sys
import base64
from urllib import quote_plus

##
# WAS 6.1 uses Python version 2.1 which doesn't support boolean literals True and False
##
if sys.version[:3] == "2.1":
    global False
    False = 0
    global True
    True = 1

class DictionaryObject:
    def __setattr__(self, propertyName, propertyValue):
        self.__dict__[propertyName] = propertyValue

    def getExposedPropertyNames(self):
        propertiesNotToExpose = ['standardPropertiesNotToExpose', 'additionalPropertiesNotToExpose']    
        if self.__dict__.has_key('standardPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['standardPropertiesNotToExpose'].split(',')))
        if self.__dict__.has_key('additionalPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['additionalPropertiesNotToExpose'].split(',')))
        return [p for p in self.properties if p not in propertiesNotToExpose]

    def getExposedProperties(self):
        propertiesNotToExpose = ['standardPropertiesNotToExpose', 'additionalPropertiesNotToExpose']    
        if self.__dict__.has_key('standardPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['standardPropertiesNotToExpose'].split(',')))
        if self.__dict__.has_key('additionalPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['additionalPropertiesNotToExpose'].split(',')))
        n = {}
        for k in self.__dict__.keys():
             if k not in propertiesNotToExpose:
                 n[k] = self.__dict__[k]
        return n

def inspected(name, value):
    if isinstance(value, type([])):
        print "INSPECTED:" + quote_plus(name) + "=" + ",".join([quote_plus(str(elt)) for elt in value])
    else:
        print "INSPECTED:" + quote_plus(name) + "=" + quote_plus(str(value))

def discovered(id, type):
    print "DISCOVERED:" + quote_plus(id) + "=" + quote_plus(type)
    
# Take a list of string objects and return the same list
# stripped of extra whitespace.
def striplist(l):
    return([x.strip() for x in l])
