/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.python.PythonDaemonException;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonStep;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PythonDaemon
implements ExecutionContextListener {
    private static final String DAEMON_SCRIPT = "python/daemon/daemon.py";
    private static final String DAEMON_STARTED = "DEPLOYIT-DAEMON-STARTED";
    private static final String DAEMON_EXIT_CODE_MARKER = "DEPLOYIT-DAEMON-EXIT-VALUE: ";
    private static final String DAEMON_END_OF_STDOUT_MARKER = "DEPLOYIT-DAEMON-END-OF-STDOUT";
    private static final String DAEMON_END_OF_STDERR_MARKER = "DEPLOYIT-DAEMON-END-OF-STDERR";
    private static final int FLUSH_DELAY_MS = 5000;
    private static final int FLUSH_CHECK_INTERVAL_MS = 2000;
    private static final Timer flushTimer = new Timer("PythonDaemon-AutoFlushTimer", true);
    private final PythonManagingContainer container;
    private OverthereConnection connection;
    private OverthereProcess process;
    private static final Logger logger = LoggerFactory.getLogger(PythonDaemon.class);

    PythonDaemon(PythonManagingContainer pythonManagingContainer) {
        this.container = pythonManagingContainer;
    }

    void start(ExecutionContext executionContext) {
        executionContext.logOutput("Starting Python daemon on " + this.container.getHost());
        this.connection = this.container.getHost().getConnection();
        logger.info("Starting Python daemon on {}", (Object)this.connection);
        OverthereFile overthereFile = this.uploadDaemonScript();
        this.waitForDaemonStart(executionContext, overthereFile);
    }

    protected OverthereFile uploadDaemonScript() {
        String string = this.generateDaemonScript();
        PythonStep.dumpPythonScript("daemon.py", string);
        return ScriptUtils.uploadScript((OverthereConnection)this.connection, (String)"daemon.py", (String)string);
    }

    private String generateDaemonScript() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ScriptUtils.loadScriptDir((String)"python/runtime"));
        stringBuilder.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
        stringBuilder.append("#\nconnectFromDaemon()\n");
        stringBuilder.append(ScriptUtils.loadScript((String)DAEMON_SCRIPT));
        stringBuilder.append("#\ndisconnectFromDaemon()\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForDaemonStart(final ExecutionContext executionContext, OverthereFile overthereFile) {
        block17: {
            this.process = this.connection.startProcess(this.container.getScriptCommandLine(overthereFile));
            InputStreamReader inputStreamReader = new InputStreamReader(this.process.getStdout());
            final StringBuilder stringBuilder = new StringBuilder();
            final long[] lArray = new long[1];
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder stringBuilder2 = stringBuilder;
                    synchronized (stringBuilder2) {
                        if (lArray[0] < System.currentTimeMillis()) {
                            if (stringBuilder.length() > 0) {
                                executionContext.logOutput(stringBuilder.toString());
                                stringBuilder.setLength(0);
                            }
                            lArray[0] = System.currentTimeMillis() + 5000L;
                        }
                    }
                }
            };
            flushTimer.schedule(timerTask, 5000L, 2000L);
            while (true) {
                try {
                    StringBuilder stringBuilder2;
                    char c;
                    do {
                        int n;
                        if ((n = inputStreamReader.read()) == -1) {
                            int n2;
                            this.captureStderr(executionContext, this.process);
                            int n3 = -1;
                            try {
                                n2 = this.process.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                logger.error("Interrupted while waiting for " + this.process + " to complete");
                                Thread.currentThread().interrupt();
                            }
                            throw new PythonDaemonException("Cannot start python daemon: exit code " + n2);
                        }
                        c = (char)n;
                        if (c == '\r' || c == '\n') continue;
                        stringBuilder2 = stringBuilder;
                        synchronized (stringBuilder2) {
                            stringBuilder.append(c);
                        }
                    } while (c != '\n');
                    stringBuilder2 = stringBuilder;
                    synchronized (stringBuilder2) {
                        lArray[0] = System.currentTimeMillis() + 5000L;
                        String string = stringBuilder.toString();
                        executionContext.logOutput(string);
                        stringBuilder.setLength(0);
                        if (string.startsWith(DAEMON_STARTED)) {
                            break block17;
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new PythonDaemonException("Cannot start python daemon", iOException);
                }
            }
            finally {
                timerTask.cancel();
            }
        }
    }

    private void captureStderr(ExecutionContext executionContext, OverthereProcess overthereProcess) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(overthereProcess.getStderr()));
        while ((string = bufferedReader.readLine()) != null) {
            executionContext.logError(string);
        }
    }

    int executePythonScript(final ExecutionContext executionContext, OverthereFile overthereFile) {
        try {
            logger.info("Executing Python script {} on {} (with daemon)", (Object)overthereFile, (Object)this.connection);
            String string = "runScriptFromDaemon(" + PythonVarsConverter.toPythonString(overthereFile.getPath()) + ")\n";
            OutputStream outputStream = this.process.getStdin();
            outputStream.write(string.getBytes());
            outputStream.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getStdout()));
            final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getStderr()));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string;
                        while (!Thread.interrupted() && (string = bufferedReader2.readLine()) != null && !string.equals(PythonDaemon.DAEMON_END_OF_STDERR_MARKER)) {
                            executionContext.logError(string);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }, "stderr printer for python daemon running on " + this);
            thread.start();
            int n = 0;
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) == null) {
                    throw new RuntimeIOException("Cannot execute script " + overthereFile.getPath() + " on " + this.container.getHost() + ": lost connection to the python daemon");
                }
                if (string2.startsWith(DAEMON_EXIT_CODE_MARKER)) {
                    try {
                        n = Integer.parseInt(string2.substring(DAEMON_EXIT_CODE_MARKER.length()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string2.equals(DAEMON_END_OF_STDOUT_MARKER)) break;
                executionContext.logOutput(string2);
            }
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                logger.error("Interrupted while waiting for " + thread + " to complete");
                Thread.currentThread().interrupt();
            }
            return n;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot execute script " + overthereFile.getPath() + " on " + this.container.getHost(), (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed() {
        OutputStream outputStream = this.process.getStdin();
        try {
            outputStream.write("QUIT\r\n".getBytes());
            outputStream.flush();
            this.process.waitFor();
        }
        catch (IOException iOException) {
            logger.error("Error stopping python daemon", (Throwable)iOException);
        }
        catch (RuntimeException runtimeException) {
            logger.error("Error stopping python daemon", (Throwable)runtimeException);
        }
        catch (InterruptedException interruptedException) {
            logger.error("Error stopping python daemon", (Throwable)interruptedException);
        }
        finally {
            Closeables.closeQuietly((Closeable)this.connection);
        }
    }
}

