package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Strings.isNullOrEmpty;
import static com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder.resolveExpression;

public class ControlTaskDelegate {

    public static List<Step> dispatch(String name, Map<String,String> args, ConfigurationItem item, Container container) {
        String script = args.get("script");
        String lang = args.get("language");

        if (isNullOrEmpty(script)) {  //backward compatibility (WLS plugin and control task hotfix)
            String scriptPropertyName = name + "PythonScript";
            Descriptor descriptor = DescriptorRegistry.getDescriptor(item.getType());
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(scriptPropertyName);
            checkArgument(propertyDescriptor!= null, "Control task script property %s not defined for CI type %s", scriptPropertyName, item.getType());
            script = (String) propertyDescriptor.get(item);
            script = script.endsWith(".py") ? script : script + ".py";
            lang = "python";
        }

        checkArgument(!isNullOrEmpty(script), "Argument 'script' is required.");
        checkArgument(!isNullOrEmpty(lang), "Argument 'language' is required.");
        checkArgument(lang.equals("python") || lang.equals("os") , "Argument 'language' can only have the values 'os' or 'python' but was %s.",lang);

        String itemVarContextName = (item instanceof Container) ? "container":"deployed";
        Map<String, Object> thisVarContext = Collections.singletonMap(itemVarContextName, (Object) item);

        String desc = "Executing " + name + " on " + item;
        if (lang.equals("os")) {
            String scriptName = resolveExpression(script, thisVarContext);
            checkArgument(container instanceof HostContainer, "Control task '%s' with shell script '%s' can only be run against a container implementing remote.HostContainer. Container '%s' does not.", name, scriptName, container);
            return Collections.<Step>singletonList(new ScriptExecutionStep(1, scriptName, (HostContainer) container, thisVarContext, desc));
        } else {
            String scriptName = resolveExpression(script, thisVarContext);
            PythonManagingContainer pythonManagingContainer = null;
            if (container instanceof PythonManagedContainer) {
                pythonManagingContainer = ((PythonManagedContainer)container).getManagingContainer();
            } else if (container instanceof  PythonManagingContainer) {
                pythonManagingContainer = (PythonManagingContainer) container;
            }

            if (pythonManagingContainer == null) {
                throw new IllegalArgumentException(String.format("Control task '%s' with python script '%s' can only be run against a container that is a python.PythonManagingContainer or implements python.PythonManagedContaner. Container '%s' does not.", name, scriptName, container));
            }

            return Collections.<Step>singletonList(new PythonDeploymentStep(1, pythonManagingContainer, scriptName, thisVarContext, desc));
        }
    }
}
