/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import java.io.Closeable;
import java.util.Timer;
import java.util.TimerTask;

public class AutoFlushingExecutionContextOverthereProcessOutputHandler
implements OverthereProcessOutputHandler,
Closeable {
    public static final int FLUSH_DELAY_MS = 5000;
    public static final int FLUSH_CHECK_INTERVAL_MS = 2000;
    private static final Timer flushTimer = new Timer("AutoFlushTimer", true);
    private ExecutionContext ctx;
    private StringBuilder lineBuffer;
    private long flushAfter;
    private TimerTask flushTimerTask;

    public AutoFlushingExecutionContextOverthereProcessOutputHandler(ExecutionContext ctx) {
        this.ctx = ctx;
        this.lineBuffer = new StringBuilder();
        this.flushAfter = this.nextFlushTime();
        this.flushTimerTask = new TimerTask(){

            @Override
            public void run() {
                AutoFlushingExecutionContextOverthereProcessOutputHandler.this.checkFlushNeeded();
            }
        };
        flushTimer.schedule(this.flushTimerTask, 5000L, 2000L);
    }

    public void handleOutputLine(String line) {
    }

    public void handleErrorLine(String line) {
        this.ctx.logError(line);
    }

    public void handleOutput(char c) {
        if (c != '\r' && c != '\n') {
            this.appendToLineBuffer(c);
        }
        if (c == '\n') {
            this.flushLineBuffer();
        }
    }

    private synchronized void appendToLineBuffer(char c) {
        this.lineBuffer.append(c);
    }

    private synchronized void checkFlushNeeded() {
        if (this.flushAfter < System.currentTimeMillis()) {
            this.flushLineBuffer();
        }
    }

    private synchronized void flushLineBuffer() {
        if (this.lineBuffer.length() > 0) {
            this.ctx.logOutput(this.lineBuffer.toString());
            this.lineBuffer.setLength(0);
        }
        this.flushAfter = this.nextFlushTime();
    }

    private long nextFlushTime() {
        return System.currentTimeMillis() + 5000L;
    }

    @Override
    public synchronized void close() {
        this.flushTimerTask.cancel();
    }
}

