package com.xebialabs.deployit.plugin.overthere;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.overthere.cifs.CifsConnectionType;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = CifsUsernameValidation.Validator.class, type = "cifsUsernameCheck")
@Target(ElementType.TYPE)
public @interface CifsUsernameValidation {

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Host> {

        @Override
        public void validate(Host value, ValidationContext context) {
            if (value.getProperty("protocol").equals("cifs")) {
                checkCifsHostUsername(value, context);
            }
        }

        private void checkCifsHostUsername(Host value, ValidationContext context) {
            CifsConnectionType connectionType = value.getProperty("connectionType");
            String username = value.getProperty("username");
            switch (connectionType) {
                case TELNET:
                    if (username.contains("@")) {
                        context.error("CIFS/Telnet host [%s] cannot have a new-style domain username (%s).", value.getId(), username);
                    }
                    break;
                case WINRM_INTERNAL:
                case WINRM_NATIVE:
                    if (username.contains("\\")) {
                        context.error("CIFS/%s host [%s] cannot have an old-style domain username (%s).", connectionType, value.getId(), username);
                    }
                    break;
            }
        }

    }

}
