package com.xebialabs.xldeploy.auth.oidc.web;

import com.xebialabs.deployit.util.MustacheRenderer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.HttpMethod;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


public class XlDeployLoginFormFilter extends UsernamePasswordAuthenticationFilter {
    public static final String DEFAULT_LOGIN_URL = "/login";
	public static final String ERROR_PARAMETER_NAME = "error";

    private static final String POST = HttpMethod.POST;
    private static final String GET = HttpMethod.GET;

    private final RequestMatcher requiresAuthenticationRequestMatcher;

    private final Map<String, String> settings;
    private final Resource layout;
    private final Resource content;
    private final String loginUrl;

    public XlDeployLoginFormFilter(Map<String, String> settings) {
        this(DEFAULT_LOGIN_URL, settings);
    }

    public XlDeployLoginFormFilter(String loginUrl, Map<String, String> settings) {
        this(loginUrl,
            new ClassPathResource("com/xebialabs/platform/sso/oidc/web/modal-layout.mustache"),
            new ClassPathResource("com/xebialabs/platform/sso/oidc/web/login.mustache"), settings);
    }

    public XlDeployLoginFormFilter(String loginUrl, Resource layout, Resource content, Map<String, String> settings) {
        this.requiresAuthenticationRequestMatcher = new AntPathRequestMatcher(loginUrl);

        this.loginUrl = loginUrl;
        this.settings = settings;
        this.layout = layout;
        this.content = content;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws AuthenticationServiceException, IOException, ServletException {
        final HttpServletRequest request = (HttpServletRequest) req;
        final HttpServletResponse response = (HttpServletResponse) res;

        if (requiresAuthenticationRequestMatcher.matches(request)) {
            if (request.getMethod().equals(GET)) {
                Map<String, String> context = new HashMap<>(settings);
                context.put("loginUrl", ((HttpServletRequest) req).getContextPath() + loginUrl);
                context.put(ERROR_PARAMETER_NAME, request.getParameter(ERROR_PARAMETER_NAME));

                Map<String, Resource> partials = new HashMap<>();
                partials.put("content", content);

                MustacheRenderer mustacheRenderer = new MustacheRenderer(layout, partials, context);
                mustacheRenderer.render(response);
            } else if (request.getMethod().equals(POST)) {
                super.doFilter(request, response, chain);
            } else {
                throw new AuthenticationServiceException("Authentication method must be a POST or GET got: " + request.getMethod());
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}
