/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.core.rest.view;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * The object container for transformation input, output and diff for documents.
 */
@PublicApiRef
public class InvocationDiffView extends InvocationOutput {
  private String diff;

  public InvocationDiffView() {
  }

  public InvocationDiffView(String input, String output, String diff) {
    super(input, output);
    this.diff = diff;
  }

  /**
   * Returns diff object as string.
   *
   * @return The diff for input and output adopted for text preview.
   */
  public String getDiff() {
    return diff;
  }

  /**
   * Sets diff object as string.
   *
   * @param diff The diff for input and output adopted for text preview.
   */
  public void setDiff(String diff) {
    this.diff = diff;
  }
}
