/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.tests.deployed;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.ExecutedScript;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugins.tests.step.LocalHttpTesterStep;
import com.xebialabs.deployit.plugins.tests.step.RemoteHttpTesterStep;

@Metadata(virtual=true, description="Base class for the http request testers")
public class BaseHttpRequestTester
extends ExecutedScript<Deployable> {
    @Property(description="The URL to test")
    private String url;
    @Property(size=Property.Size.LARGE, description="Text that is expected to be contained in the HTTP response body, if the response code is in the 200 range. A non-2xx response code will cause the test to fail irrespective of the response body")
    private String expectedResponseText;
    @Property(description="Show the page retrieved from the url")
    private boolean showPageInConsole;
    @Property(required=false, hidden=true, description="Time in seconds to wait before starting the execution of step")
    private int startDelay = 0;
    @Property(required=false, hidden=true, description="Number of times to attempt executing the step, incase it fails")
    private int noOfRetries = 0;
    @Property(required=false, hidden=true, description="Time in seconds to wait before next retry")
    private int retryWaitInterval = 0;

    public void executeCreate(DeploymentPlanningContext ctx, Delta d) {
        if (((Container)this.getContainer()).getHost().getType().equals((Object)Type.valueOf((String)"overthere.LocalHost"))) {
            ctx.addStep((DeploymentStep)new LocalHttpTesterStep(this.getCreateOrder(), this.getDescription(this.getCreateVerb()), (Container)this.getContainer(), this.getUrl(), this.getExpectedResponseText(), this.getStartDelay(), this.getNoOfRetries(), this.getRetryWaitInterval(), this.isShowPageInConsole()));
        } else {
            ctx.addStep((DeploymentStep)new RemoteHttpTesterStep(this.getCreateOrder(), this.getCreateScript(), (Container)this.getContainer(), this.getDeployedAsFreeMarkerContext(), this.getDescription(this.getCreateVerb()), this.getStartDelay(), this.getNoOfRetries(), this.getRetryWaitInterval()));
        }
    }

    public void executeDestroy(DeploymentPlanningContext ctx, Delta d) {
    }

    public String getHostTemporaryDirectoryOrDefault() {
        Host host = ((Container)this.getContainer()).getHost();
        String hostTemporaryDirectory = Strings.nullToEmpty((String)host.getTemporaryDirectoryPath());
        return !hostTemporaryDirectory.isEmpty() ? hostTemporaryDirectory : host.getOs().getDefaultTemporaryDirectoryPath();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getExpectedResponseText() {
        return this.expectedResponseText;
    }

    public void setExpectedResponseText(String expectedResponseText) {
        this.expectedResponseText = expectedResponseText;
    }

    public boolean isShowPageInConsole() {
        return this.showPageInConsole;
    }

    public void setShowPageInConsole(boolean showPageInConsole) {
        this.showPageInConsole = showPageInConsole;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public int getNoOfRetries() {
        return this.noOfRetries;
    }

    public void setNoOfRetries(int noOfRetries) {
        this.noOfRetries = noOfRetries;
    }

    public int getRetryWaitInterval() {
        return this.retryWaitInterval;
    }

    public void setRetryWaitInterval(int retryWaitInterval) {
        this.retryWaitInterval = retryWaitInterval;
    }
}

