<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
@echo off
setlocal enabledelayedexpansion
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
set ${envVar}="${envVars[envVar]}"
</#list>
cd /D "${container.home}"
goto :checkStatus

:checkStatus
<#if container.statusCommand??>
${container.statusCommand}
if not %ERRORLEVEL% == 0 goto :errorStatusResponse
if !pid! gtr 0 (
echo Tomcat server is already running
goto :EOF
)  else (
goto :startTomcat
)
<#elseif container.tomcatRunningPort??>
for /f "tokens=5" %%a in ('netstat -aon ^| findstr 0.0.0.0:${container.tomcatRunningPort}') do set pid=%%~nxa
if !pid! gtr 0 (
echo Tomcat server is already running
)  else (
goto :startTomcat
)
<#else>
goto :startTomcat
</#if>
goto :EOF

:startTomcat
${container.startCommand}
if not %ERRORLEVEL% == 0 goto :errorStartResponse
PING localhost -n ${container.serverStartupTime} >NUL
goto :checkStatusAndShowResult

:checkStatusAndShowResult
<#if container.statusCommand??>
${container.statusCommand}
<#elseif container.tomcatRunningPort??>
for /f "tokens=5" %%a in ('netstat -aon ^| findstr 0.0.0.0:${container.tomcatRunningPort}') do set pid=%%~nxa
<#else>
echo Server running status is not checked and executed tomcat start command
goto :EOF
</#if>
goto :showResult

:showResult
if !pid! gtr 0 (
echo Tomcat server is started
) else (
echo server is not started. Check the start and status commands
)
goto :EOF

:errorStatusResponse
echo Check the status command
goto :EOF

:errorStartResponse
echo Check the start command
goto :EOF

:EOF
