<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
${envVar}="${envVars[envVar]}"
export ${envVar}
</#list>
status=UNKNOWN
cd "${container.home}"

check_status() {
    if [ "$match1" -gt 0 ] ; then
        status=RUNNING
    elif [ $? -eq 1 ] ; then
        status=STOPPED
    elif [ $? -gt 1 ] ; then
        status=STOPPED
        echo "Incorrect command. , Exit Code Returned  $?"
        exit 1
    else
        echo "Could Not Determine Status."
        status=STOPPED
    fi
    echo "Server is currently $status"
}

echo 'Checking server status...'
<#if (container.statusCommand)?? && (container.statusCommandExpectedOutput)??>
    match1=$(${container.statusCommand} | grep -c "${container.statusCommandExpectedOutput}")
    check_status
<#else>
    echo "Set status command and Status Command Expected Output."
</#if>
