/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

public class RenameFileStep
extends BaseDeploymentStep {
    private String source;
    private String target;

    public RenameFileStep(int order, String source, String target, String description, HostContainer container) {
        super(order, description, container);
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)source));
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)target));
        this.source = source;
        this.target = target;
    }

    protected StepExitCode doExecute() throws Exception {
        OverthereFile sourceFile = this.getRemoteConnection().getFile(this.source);
        OverthereFile targetFile = this.getRemoteConnection().getFile(this.target);
        if (targetFile.exists()) {
            this.getCtx().logError("Source file " + this.source + " cannot be renamed to " + this.target + ", because file already exists.");
            return StepExitCode.FAIL;
        }
        this.getCtx().logOutput("Copying file " + this.source + " to " + this.target + ".");
        sourceFile.copyTo(targetFile);
        this.getCtx().logOutput("Removing file " + this.source);
        sourceFile.deleteRecursively();
        return StepExitCode.SUCCESS;
    }
}

